#include "GetPoint.js"

function DoLeader()
{
	var pointpicker = moi.ui.createPointPicker();

	var projecttocplane = false;
	try {
		projecttocplane = moi.command.getOption( 'DimProjectToCPlane', true );
		moi.ui.commandUI.ProjectToCPlane.value = projecttocplane;
	} catch(e) {}

	if ( projecttocplane )
		pointpicker.projectToCPlane = true;

	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'finished' )
			break;

		if ( pointpicker.event == 'ProjectToCPlane' )
		{
			projecttocplane = moi.ui.commandUI.ProjectToCPlane.value;
			pointpicker.projectToCPlane = projecttocplane;
		}
	}

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'BasePtPrompt' );
	moi.ui.showUI( 'NextPtPrompt' );
	moi.ui.hideUI( 'Options' );
	moi.ui.endUIUpdate();


	var factory = moi.command.createFactory( 'leader' );
	factory.setInput( 0, pointpicker.ptFrame );

	pointpicker.projectToCPlane = false;
	pointpicker.disableVerticalStraightSnap = true;

	if ( projecttocplane )
		pointpicker.restrictToPlane( pointpicker.cplane, true );
	else
		pointpicker.restrictToPlaneThroughPt( pointpicker.pt, false );

	factory.createInput( 'point' );
	var pointindex = factory.numInputs - 1;
		
	pointpicker.clearBindings();
	pointpicker.bindResultPt( factory.getInput(pointindex) );

	if ( !projecttocplane )
		pointpicker.bindResultOrientation( factory.getInput(0) );

	while ( true )
	{
		if ( !pointpicker.waitForEvent() )
			return false;

		if ( pointpicker.event == 'finished' )
		{
			factory.createInput( 'point' );
			var pointindex = factory.numInputs - 1;
		
			pointpicker.clearBindings();
			pointpicker.bindResultPt( factory.getInput(pointindex) );
		}

		if ( pointpicker.event == 'done' )
		{
			factory.removeLastInput();
			factory.update();
			break;
		}
	}

	if ( factory.numInputs < 3 )
		return;

	moi.ui.clearPickedPoints();

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'NextPtPrompt' );
	moi.ui.showUI( 'OptionsPrompt' );
	moi.ui.hideUI( 'done' );
	moi.ui.hideUI( 'cancel' );
	moi.ui.endUIUpdate();


	var dlg = moi.ui.createDialog( 'moi://commands/AnnotationTextDialog.htm?type=leader&titleid=Leader options prompt', 'resizeable,defaultWidth:26em,defaultHeight:18em', moi.ui.mainWindow );
	dlg.htmlWindow.g_Factory = factory;

	if ( dlg.window.doModal() == -1 )
	    return;

	factory.commit();

	moi.command.setOption( 'DimProjectToCPlane', projecttocplane, true );
}

DoLeader();
